/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.base.PathUtils;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.adaptors.webservices.WSInvokeOperation;
import filenet.vw.integrator.adaptors.webservices.WSReplyOperation;
import filenet.vw.integrator.adaptors.webservices.WSRequestOperation;
import filenet.vw.integrator.base.VWAdaptorControlEx;
import filenet.vw.integrator.base.VWAdaptorEx;
import filenet.vw.integrator.base.VWResources;
import filenet.vw.server.VWCapsule;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.listener.axis.rm.WSRMCallback;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.axis.rm.WSUUIDGenFactory;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.att.IWSAttSession;
import filenet.ws.utils.jsse.WSJSSE;
import java.net.BindException;
import org.apache.sandesha.SandeshaContext;
import org.apache.sandesha.client.ClientListener;
import org.apache.sandesha.server.Sender;
import org.apache.sandesha.server.SenderWorker;
import org.apache.sandesha.storage.Callback;
import org.apache.sandesha.util.PropertyLoader;
import org.apache.sandesha.ws.rm.providers.RMProvider;

public class VWWebServicesAdaptorEx
extends VWAdaptorEx {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.Dispatcher");
    protected static final String g_className = "VWWebServicesAdaptor:";
    protected ClientListener rmClientListener = null;
    public static WSListenerProperties gWSListenerProperties = null;
    private VWSession session = null;
    private static String[] WSRequestPollingPropertyNames = new String[]{"cm.ws.request.polling.interval", "cm.ws.request.max.polling.interval", "filenet.ws.request.concurrent.threads"};
    private static Class wsSessionHandlerClass = null;
    private static boolean wsSessionHandlerClassChecked = false;

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2010 10:24:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.0  $";
    }

    public static void STATIC_INITIALIZER(String connectionPoint) {
        try {
            gWSListenerProperties = WSListenerProperties.instance(new PathUtils(), connectionPoint);
            WSJSSE.installAxisJSSESocketFactory(gWSListenerProperties);
            WSRMCallback cb = WSRMCallback.getCallbackInstance();
            RMProvider.setCallback((Callback)cb);
            Sender.setCallback((Callback)cb);
            SenderWorker.setCallback((Callback)cb);
            WSUUIDGenFactory.getUUIDGen();
            WSRMUtils.setWSListenerProperties(gWSListenerProperties);
            WSWSRRRegistry.addIBMSecurityProviders();
        }
        catch (Exception ex) {
            logger.throwing(g_className, "static initializer", ex);
        }
    }

    public VWWebServicesAdaptorEx(VWQueue queue, String component_descriptor, int index, VWAdaptorControlEx parent) throws Exception {
        super(queue, component_descriptor, index, parent);
        if (queue != null) {
            this.session = queue.getServiceSession();
        }
        if (gWSListenerProperties == null) {
            VWWebServicesAdaptorEx.STATIC_INITIALIZER(queue.getServiceSession().getConnectionPointName());
        }
        this.m_className = "VWWebServicesAdaptorEx:" + this.m_id;
        this.setName(this.m_className);
        if (gWSListenerProperties != null) {
            gWSListenerProperties.WSRMSandeshaSettings();
        }
        if (index == 1) {
            this.rmClientListener = new ClientListener(PropertyLoader.getClientSideListenerPort());
        }
    }

    public static boolean GetWSRequestValidateMessages() {
        boolean res = false;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.validate.messages")) != null) {
                res = new Boolean(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetPollingRate() {
        long res = 1000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("cm.ws.request.polling.interval")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetMaxPollingRate() {
        long res = 60000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("cm.ws.request.max.polling.interval")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static long GetConcurentThreads() {
        long res = 1L;
        try {
            if (gWSListenerProperties != null) {
                String s = gWSListenerProperties.getProperty("filenet.ws.request.concurrent.threads");
                if (s == null) {
                    s = System.getProperty("filenet.ws.num.threads", "1");
                }
                logger.finest("VWWebServicesAdaptor", "GetConcurrentThreads -- really", s);
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PersistComponentDescriptor(String component_descriptor) {
        block8: {
            try {
                String concurrentThreads;
                String maxpr;
                if (gWSListenerProperties == null) break block8;
                VWXMLWrapper cdoc = new VWXMLWrapper(component_descriptor);
                String pr = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "polling_rate");
                if (pr == null) {
                    pr = "1000";
                }
                if ((maxpr = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "max_polling_rate")) == null) {
                    maxpr = "60000";
                }
                if ((concurrentThreads = VWXMLWrapper.getNodeValue(cdoc.getRootNode(), "concurrent_threads")) == null) {
                    concurrentThreads = "1";
                }
                WSListenerProperties wSListenerProperties = gWSListenerProperties;
                synchronized (wSListenerProperties) {
                    gWSListenerProperties.setProperties(WSRequestPollingPropertyNames, new String[]{pr, maxpr, concurrentThreads}, true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int GetWsTimeout() {
        int res = 300000;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("synchronous.timeout")) != null) {
                res = Integer.parseInt(s) * 1000;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static long GetWSRequestCacheTimeout() {
        long res = 4L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.cache.timeout")) != null) {
                res = Long.parseLong(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res * 60L * 60L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class getWSSessionHandlerClass() {
        if (wsSessionHandlerClass != null || wsSessionHandlerClassChecked) return wsSessionHandlerClass;
        String string = g_className;
        synchronized (g_className) {
            wsSessionHandlerClassChecked = true;
            if (wsSessionHandlerClass != null) return wsSessionHandlerClass;
            String handlerClassName = null;
            if (gWSListenerProperties != null) {
                handlerClassName = gWSListenerProperties.getProperty("att.handler");
            }
            if (handlerClassName == null) {
                handlerClassName = "filenet.vw.idm.trident.WSSession";
            }
            try {
                wsSessionHandlerClass = Class.forName(handlerClassName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return wsSessionHandlerClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWSAttSession getWSSession(String username, String password) {
        Class cls;
        block5: {
            String m_method = "getWSSession:" + username;
            cls = VWWebServicesAdaptorEx.getWSSessionHandlerClass();
            if (cls != null) break block5;
            IWSAttSession iWSAttSession = null;
            return iWSAttSession;
        }
        try {
            IWSAttSession res = (IWSAttSession)cls.newInstance();
            res.setCredentials(username, password);
            IWSAttSession iWSAttSession = res;
            return iWSAttSession;
        }
        catch (Throwable t) {
            IWSAttSession iWSAttSession = null;
            return iWSAttSession;
        }
    }

    private static String GetMyListenerURL() {
        String m_method = "getMyListenerURL";
        String res = null;
        try {
            if (gWSListenerProperties != null) {
                res = gWSListenerProperties.getProperty("listener.base.url");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "getMyListenerURL", res);
        }
        return res;
    }

    private static String GetTraceFile() {
        String m_method = "GetTraceFile";
        String res = null;
        try {
            if (gWSListenerProperties != null) {
                res = gWSListenerProperties.getProperty("filenet.ws.request.tracefile");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "GetTraceFile", res);
        }
        return res;
    }

    private static long GetTraceFileSize() {
        long res = 5000000L;
        try {
            String s;
            if (gWSListenerProperties != null && (s = gWSListenerProperties.getProperty("filenet.ws.request.tracefilesize")) != null) {
                try {
                    res = Long.parseLong(s);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private static boolean GetTraceOption() {
        String m_method = "getTraceOption";
        boolean res = false;
        try {
            if (gWSListenerProperties != null) {
                res = new Boolean(gWSListenerProperties.getProperty("filenet.ws.request.tracing", "true"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(g_className, "getTraceOption", new Boolean(res).toString());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        logger.entering(this.m_className, "run");
        try {
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STARTING.toString(this.m_id, this.getLocaleDateStringNow());
            this.done = false;
            this.startTime = System.currentTimeMillis();
            this.callTime = 0.0;
            this.callCount = 0.0;
            if (this.component_descriptor_doc == null) {
                throw new VWException("vw.integrator.base.NoComponentDescriptor", "Unable to obtain valid component descriptor for {0}.", this.m_id);
            }
            String username = null;
            String password = null;
            VWAuthItem itm = this.m_parent.getPrivateCredentials();
            if (itm != null) {
                username = itm.getName();
                password = itm.getPassword();
            }
            if (username == null || password == null) {
                username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
                password = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_password");
                VWCapsule capsule = new VWCapsule();
                capsule.setString(password);
                password = capsule.getString();
            }
            String routerurl = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "routerurl");
            if (this.m_index == 1 && this.rmClientListener != null) {
                try {
                    this.rmClientListener.start();
                    SandeshaContext.init((boolean)true);
                }
                catch (BindException e) {
                    VWException ex = new VWException("vw.integrator.base.FailedStartRMClientListener", "Failed to establish connection to the Reliable Messaging client listener port {0}: {1}.", Integer.toString(PropertyLoader.getClientSideListenerPort()), e.getMessage());
                    ex.setCause(e);
                    throw ex;
                }
                catch (Exception e) {
                    VWException ex = new VWException("vw.integrator.base.FailedToInitalizedSandesha", "Failed to initialized Sandesha for Reliable Messaging: {0}.", e.getMessage());
                    ex.setCause(e);
                    throw ex;
                }
            }
            IWSAttSession wsSession = null;
            while (!this.done) {
                if (!this.gotWork()) continue;
                try {
                    int wsTimeout = VWWebServicesAdaptorEx.GetWsTimeout();
                    try {
                        long tempCallTime = System.currentTimeMillis();
                        String opName = this.se.getOperationName();
                        String wobId = this.se.getWorkObjectNumber();
                        String workflowName = this.se.getWorkflowName();
                        this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSINGSE.toString(new Object[]{this.m_id, opName, wobId, workflowName, this.getLocaleDateStringNow()});
                        gWSListenerProperties.WSRMSandeshaSettings();
                        if (wsSession == null) {
                            wsSession = this.getWSSession(username, password);
                        }
                        try {
                            WSRequestOperation wsOp;
                            String opStatus = "UNKNOWN";
                            if (opName.equals("Invoke")) {
                                wsOp = new WSInvokeOperation(this.session, wsSession, wsTimeout, VWWebServicesAdaptorEx.GetTraceOption(), VWWebServicesAdaptorEx.GetTraceFile(), VWWebServicesAdaptorEx.GetTraceFileSize(), VWWebServicesAdaptorEx.GetWSRequestCacheTimeout(), VWWebServicesAdaptorEx.GetMyListenerURL(), VWWebServicesAdaptorEx.GetWSRequestValidateMessages(), this.m_index, username, password);
                                opStatus = ((WSInvokeOperation)wsOp).invoke(this.se);
                            } else {
                                wsOp = new WSReplyOperation(this.session, wsSession, wsTimeout, VWWebServicesAdaptorEx.GetTraceOption(), VWWebServicesAdaptorEx.GetTraceFile(), VWWebServicesAdaptorEx.GetTraceFileSize(), VWWebServicesAdaptorEx.GetWSRequestCacheTimeout(), VWWebServicesAdaptorEx.GetWSRequestValidateMessages(), this.m_index);
                                opStatus = ((WSReplyOperation)wsOp).reply(this.se);
                            }
                            this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSED_SE_STATUS.toString(new Object[]{this.m_id, opName, wobId, workflowName, opStatus, this.getLocaleDateStringNow()});
                            logger.info(this.m_className, "run", this.m_status);
                        }
                        catch (Exception e) {
                            this.m_status = VWResources.VWS_WSADAPTOR_RUN_PROCESSINGSE_EX.toString(new Object[]{this.m_id, opName, wobId, workflowName, this.getLocaleDateStringNow(), VWException.DescribeThrowableAndItsCause(e)});
                            logger.severe(this.m_className, "run", this.m_status);
                        }
                        Object object = this.statsSyncObj;
                        synchronized (object) {
                            this.callTime += (double)(System.currentTimeMillis() - tempCallTime);
                            this.callCount += 1.0;
                        }
                    }
                    catch (Exception e) {
                        logger.throwing(this.m_className, "run", e);
                    }
                }
                catch (Throwable t) {
                    logger.throwing("filenet.vw.integrator.base.VWAdaptor", "run", t);
                }
                finally {
                    VWAdaptorControlEx wsTimeout = this.m_parent;
                    synchronized (wsTimeout) {
                        this.m_parent.notifyAll();
                    }
                }
                this.setAvailableAgain();
            }
            if (this.rmClientListener != null) {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "run", "Stopping RM Client Listener..");
                }
                this.rmClientListener.stop();
            }
            WSRequestOperation.ClearWSDLCache();
            if (logger.isFinest()) {
                logger.finest(this.m_className, "run", "time to get out..");
            }
            if (wsSession != null) {
                try {
                    wsSession.close();
                }
                catch (Exception wse) {
                    // empty catch block
                }
            }
            if (logger.isFinest()) {
                logger.finer(this.m_className, "run", Thread.currentThread() + " - has shut down.");
            }
            this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_className, this.getLocaleDateStringNow());
        }
        catch (Exception e) {
            String s;
            String cause = VWException.DescribeThrowableAndItsCause(e);
            this.m_status = s = VWResources.VWS_ADAPTOR_RUN_STOPPED_WITH_EX.toString(new Object[]{this.m_id, cause, this.m_status});
            logger.throwing(this.m_className, "run", e);
            logger.severe(this.m_className, "run", s);
        }
        this.done = true;
        logger.exiting(this.m_className, "run");
    }
}

